/** @file   animatedobject.h
 * @brief   Declaration of AnimatedObject - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ANIMATEDOBJECT_H
#define H_WWW_ANIMATEDOBJECT_H

#include "mobileobject.h"
#include "animation.h"


namespace WeWantWar {


/** @class  AnimatedObject
 * @brief   Extends the MobileObject with animation features.
 * @author  Tomi Lamminsaari
 *
 */
class AnimatedObject : public MobileObject
{
public:

  ///
  /// Constructors, destructor
  /// ========================
  
  /** Constructor
   */
  AnimatedObject();
  
  /** Destructor.
   */
  virtual ~AnimatedObject();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Sets new animation.
   * @param     rAnim             The new animation itself.
   * @param     id                The animation id.
   */
  virtual void setAnimation( const eng2d::Animation& rAnim, int id );
  
  /** Updates the animation.
   */
  virtual void updateAnim();
  
  
  ///
  /// Getter methods
  /// ==============
  
  /** Returns the animation id.
   * @return    ID of the current animation.
   */
  int getAnimID() const;
  
  /** Returns the currently visible frame of the animation.
   * @return    Currently visible frameindex.
   */
  int getAnimFrame() const;
  
  
protected:

  ///
  /// Members
  /// =======
  
  /** The animation. */
  eng2d::Animation  m_animation;
  
  /** ID of the animation. */
  int   m_id;
  
private:
  /** Disabled copy constructor. */
  AnimatedObject( const AnimatedObject& rObj );
  /** Disabled assignment operator */
  AnimatedObject& operator = ( const AnimatedObject& rObj );
};

};  // end of namespace

#endif // ANIMATEDOBJECT_H

/**
 * Version history
 * ===============
 * $Log: animatedobject.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:47+02  lamminsa
 * Initial revision
 *
 */
 
